IF EXISTS(SELECT 1 FROM SYS.TABLES WHERE OBJECT_ID = OBJECT_ID('EST_NF_ENT_DAR_ERROS_VALIDACAO'))
BEGIN
	DROP TABLE [EST_NF_ENT_DAR_ERROS_VALIDACAO]
END

GO

CREATE TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO](
	[CD_CTR_ERROS] [INT] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [INT] NOT NULL,
	[CD_FILIAL] [INT] NOT NULL,
	[CD_NF] [INT] NOT NULL,
	[DT_CAD] [DATETIME] NOT NULL,
	[ERROS_VALIDACAO] [XML] NOT NULL,
	[STS_ERRO] [INT] NOT NULL,
	[CD_USU] [INT] NOT NULL,
	[DT_CAD_CORRECAO] [DATETIME] NULL,
	[VERSAO_APLIC] VARCHAR (150) NULL 
 CONSTRAINT [PK_EST_NF_ENT_DAR_ERROS_VALIDACAO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_ERROS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] ADD  CONSTRAINT [DF_EST_NF_ENT_DAR_ERROS_VALIDACAO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] ADD  CONSTRAINT [DF_EST_NF_ENT_DAR_ERROS_VALIDACAO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] ADD  CONSTRAINT [DF_EST_NF_ENT_DAR_ERROS_VALIDACAO_CD_NF]  DEFAULT ((0)) FOR [CD_NF]
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] ADD  CONSTRAINT [DF_EST_NF_ENT_DAR_ERROS_VALIDACAO_STS_ERRO]  DEFAULT ((0)) FOR [STS_ERRO]
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] ADD  CONSTRAINT [DF_EST_NF_ENT_DAR_ERROS_VALIDACAO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_DAR_ERROS_VALIDACAO_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [DBO].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])
GO

ALTER TABLE [DBO].[EST_NF_ENT_DAR_ERROS_VALIDACAO] CHECK CONSTRAINT [FK_EST_NF_ENT_DAR_ERROS_VALIDACAO_EST_NF_ENT]
GO


